import java.sql.*;
import java.io.*;

public class DBConsole
{
  protected Connection conn;
  protected BufferedReader brInput;
  public DBConsole(String connStr, String user, String pass)
  throws Exception
  {
    conn = DBConnection.getConnection(connStr, user, pass);
    if(conn == null){
      throw new Exception(
        "Nie mona nawiza poczenia z baz: ");
    }
    try{
      brInput = new BufferedReader(
        new InputStreamReader(System.in));
    }
    catch(Exception e){
      throw new Exception(
        "Bd przy tworzeniu strumienia wejciowego: ");
    }
  }
  public static void main(String args[])
  throws Exception
  {
    DBConsole dbcon = new DBConsole(
      "jdbc:mysql://localhost:3306/test", "test", "test");
    dbcon.start();
  }
  public void start()
  {
    String line;
    while(true){
      try{
        System.out.print(">");
        line = brInput.readLine();
        if (line.equals("quit")){
          conn.close();
          break;
        }
        else{
          doQuery(line);
        }
      }
      catch(IOException e){
        log("Bd wejcia-wyjcia: " + e);
        System.exit(-1);
      }
      catch(Exception e){
        log("Bd oglny: " + e);
        System.exit(-1);
      }
    }
  }
  public void doQuery(String query)
  {
    try{
      Statement stm = conn.createStatement();
      ResultSet rs = stm.executeQuery(query);
      ResultSetMetaData rsmd = rs.getMetaData();
      int colsNo = rsmd.getColumnCount();
      
      String result = "";
      for(int i = 1; i <= colsNo; i++){
        result += rsmd.getColumnName(i);
        result += i < colsNo ? " | " : "";
      }
      System.out.println(result);
      
      result = "";
      while(rs.next()){
        for(int i = 1; i <= colsNo; i++){
          result += rs.getString(i);
          result += i < colsNo ? " | " : "";
        }
        result += "\n";
      }
      System.out.print(result);
    }
    catch(SQLException e){
      System.out.println("Bd przy przetwarzaniu danych: " + e);
    }
  }
  public void log(String msg)
  {
    //System.out.println(msg);
  }
}
